//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiCheckButtonBase {
    id : uiToggle

    property alias text     : label.text
    property real  boxScale : 1.0

    property string colorScheme : "green"

    implicitHeight : p_.size
    implicitWidth  : {
        if (label.text.length > 0) {
            return p_.boxWidth + p_.spacing + label.implicitWidth + p_.margin;
        }

        return p_.boxWidth;
    }

    baselineOffset : label.y + label.baselineOffset

    QtObject {
        id : p_

        readonly property int size      : 18 * boxScale
        readonly property int spacing   : 5
        readonly property int margin    : 2
        readonly property int boxMargin : 2  * boxScale
        readonly property int boxWidth  : 32 * boxScale
    }

    MouseArea {
        width  : box.width + label.implicitWidth + p_.spacing
        height : parent.height
        acceptedButtons : Qt.NoButton
        hoverEnabled    : enabled
        cursorShape     : Qt.PointingHandCursor
    }

    Rectangle {
        id : box

        property color hoverColor : UiColors.getColor(UiColors.HoverGreen)
        property color pressColor : UiColors.getColor(UiColors.SelectionGreen)

        width  : p_.boxWidth
        height : p_.size
        color  : UiColors.getColor(UiColors.ControlGrey20)

        states : State {
            name : "blue"
            when : uiToggle.colorScheme === "blue"

            PropertyChanges {
                target     : box
                hoverColor : UiColors.getColor(UiColors.ButtonHoverBlue)
                pressColor : UiColors.getColor(UiColors.ButtonPressBlue)
            }
        }

        Rectangle {
            id : boxInner

            width  : box.height - p_.boxMargin * 2
            height : width
            x      : p_.boxMargin
            y      : p_.boxMargin
            color  : UiColors.getColor(UiColors.White)

            states : [
                State {
                    name : "unchecked"
                    when : uiToggle.checkState === Qt.Unchecked

                    PropertyChanges {
                        target : boxInner
                        x : p_.boxMargin
                    }
                },
                State {
                    name : "partially-checked"
                    when : uiToggle.checkState === Qt.PartiallyChecked

                    PropertyChanges {
                        target : boxInner
                        x : p_.boxMargin + boxInner.width / 2
                    }
                },
                State {
                    name : "checked"
                    when : uiToggle.checkState === Qt.Checked

                    PropertyChanges {
                        target : boxInner
                        x : box.width - p_.boxMargin - boxInner.width
                    }
                }
            ]

            transitions: [
                Transition {
                    NumberAnimation {
                        duration    : 100
                        easing.type : Easing.InOutQuad
                        property    : "x"
                    }
                }
            ]
        }
    }

    UiText {
        id : label

        visible  : text.length > 0
        width    : uiToggle.width - p_.size - p_.spacing - p_.margin
        text     : uiToggle.text
        anchors {
            left           : box.right
            leftMargin     : p_.spacing
            verticalCenter : box.verticalCenter
        }
    }

    UiFocusRect {
        anchors.centerIn : label
        width            : label.width + p_.margin * 2
        height           : label.height + 1
        target           : uiToggle
        enabled          : label.text.length > 0
    }

    states : [
        State {
            name : "disabled"
            when : !uiToggle.enabled

            PropertyChanges {
                target : box
                color  : UiColors.getColor(UiColors.DisabledLightGrey13)
            }
        },
        State {
            name : "active"
            when : uiToggle.pressed || uiToggle.checked

            PropertyChanges {
                target : box
                color  : box.pressColor
            }
        },
        State {
            name : "partially-checked"
            when : uiToggle.checkState === Qt.PartiallyChecked

            PropertyChanges {
                target : box
                color  : box.hoverColor
            }
        }

    ]
}
